varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform float		scale;

float			lum;

vec4 RGBMEncode( vec3 color ) {
  vec4 rgbm;
  color *= 1.0 / 6.0;
  rgbm.a = clamp( max( max( color.r, color.g ), max( color.b, 1e-6 ) ),0.0,1.0 );
  rgbm.a = ceil( rgbm.a * 255.0 ) / 255.0;
  rgbm.rgb = color / rgbm.a;
  return rgbm;
}

void main()
{
	vec3 texColor = texture2D(tex, texcoord).rgb;
//	lum=dot(vec3(0.2125, 0.7154, 0.0721),texColor.xyz);
	gl_FragColor=RGBMEncode(texColor);//vec4(texColor*scale,lum);
}
